

/* return true if the pwd is valid */
function pwd_check(pwd){
    const pattern =  /.+/
    return pattern.test(pwd)
} 

/* return true if email is valid */
function email_check(email){
    const pattern = /^[^\s@]+@[^\s@]+\.[^\s@]+$/
    return pattern.test(email)
}

/* upate form from pwd checking */
function pwd_check_update(input){
    if(pwd_check(input.value))
        input.nextElementSibling.style.opacity = "0"
    else
        input.nextElementSibling.style.opacity = "1"
}

/* update form from email checking */
function email_check_update(input){
    if(email_check(input.value))
        input.nextElementSibling.style.opacity = "0"
    else
        input.nextElementSibling.style.opacity = "1"
}

/* all input field */
const input_email = document.querySelector(".login-01 .form-field:first-child input")
const input_pwd = document.querySelector(".login-01 .form-field:last-child input")

/* event input handlers */
input_email.addEventListener("input", e => {email_check_update(e.target)})
input_pwd.addEventListener("input", e => {pwd_check_update(e.target)})

/* form */
const form = document.querySelector(".login-01")

/* form submission */
form.addEventListener("submit", e => {
    e.preventDefault()
    const input_pwd_check = pwd_check(input_pwd.value)
    const input_email_check = email_check(input_email.value)
    if(input_email_check && input_pwd_check){
        e.target.submit()
    }
    else{
        if(!input_email_check) email_check_update(input_email)
        if(!input_pwd_check) pwd_check_update(input_pwd)
    }
})
