

/* return true if the text is valid */
function text_check(text){
    const pattern =  /.+/
    return pattern.test(text)
} 

/* return true if email is valid */
function email_check(email){
    const pattern = /^[^\s@]+@[^\s@]+\.[^\s@]+$/
    return pattern.test(email)
}

/* upate form from text checking */
function text_check_update(input){
    if(text_check(input.value))
        input.nextElementSibling.style.display = "none"
    else
        input.nextElementSibling.style.display = "initial"
}

/* update form from email checking */
function email_check_update(input){
    if(email_check(input.value))
        input.nextElementSibling.style.display = "none"
    else
        input.nextElementSibling.style.display = "initial"
}

/* all input field */
const input_name = document.querySelector(".contact-02 .name input")
const input_email = document.querySelector(".contact-02 .email input")
const input_subject = document.querySelector(".contact-02 .subject input")
const input_message = document.querySelector(".contact-02 .message textarea")

/* event input handlers */
input_name.addEventListener("input", e => {text_check_update(e.target)})
input_email.addEventListener("input", e => {email_check_update(e.target)})
input_subject.addEventListener("input", e => {text_check_update(e.target)})
input_message.addEventListener("input", e => {text_check_update(e.target)})

/* form */
const form = document.querySelector(".contact-02 .form")

/* event submit handler*/
form.addEventListener("submit", e => {
    
    e.preventDefault()

    const input_name_check = text_check(input_name.value)
    const input_email_check = text_check(input_email.value)
    const input_subject_check = text_check(input_subject.value)
    const input_message_check = text_check(input_message.value)

    if(input_email_check && input_name_check && input_message_check && input_subject_check){
       e.target.submit()
    }
    else{
        if(!input_email_check) email_check_update(input_email)
        if(!input_name_check) text_check_update(input_name)
        if(!input_subject_check) text_check_update(input_subject)
        if(!input_message_check) text_check_update(input_message)
    }
})



